<?php
/**
 * Theme Options
 */

if ( ! givelove_page_enable_breadcrumb() ) {
	return;
}

// Get the query & post information
global $post, $wp_query;

$otf_sep   = '<i class="fa fa-angle-right"></i>';
$otf_class = 'breadcrumbs clearfix';
$otf_home  = esc_html__( 'Home', 'givelove' );
$otf_blog  = esc_html__( 'Blog', 'givelove' );
$otf_shop  = esc_html__( 'Shop', 'givelove' );
$otf_title = '';

// Get the query & post information
global $post, $wp_query;

// Get post category
$otf_category = get_the_category();

// Get gallery category
$otf_gallery_category = wp_get_post_terms( get_the_ID(), 'gallery_cat' );

// Get product category
$otf_product_cat = get_term_by( 'slug', get_query_var( 'term' ), get_query_var( 'taxonomy' ) );

if ( $otf_product_cat ) {
	$otf_tax_title = $otf_product_cat->name;
}

if ( ! function_exists( 'bcn_display' ) ) {
	$otf_output = '';
	if ( is_single() ) {
		$class_page_title = ' d-none';
	}

	if ( ! is_front_page() ) {
		$otf_output .= '<ul class="' . esc_attr( $otf_class ) . ' list-inline m-0">';
		if ( is_home() ) {
			// Home page
			$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
			$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';
			$otf_output .= '<li class="list-inline-item separator"> ' . $otf_blog . ' </li>';
			$otf_title  = $otf_blog;

		} else {
			if ( is_single() ) {
				$otf_title = get_the_title();
				$post_type = get_post_type();
				// Home page
				$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
				$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';

				if ( 'post' == $post_type && ! empty( $otf_category ) ) {
					// First post category
					$otf_output .= '<li class="list-inline-item item"><a href="' . esc_url( get_category_link( $otf_category[0]->term_id ) ) . '" title="' . esc_attr( $otf_category[0]->cat_name ) . '">' . $otf_category[0]->cat_name . '</a></li>';
					$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';

				}
				$otf_output .= '<li class="list-inline-item item current">' . $otf_title . '</li>';

			} else {
				if ( is_archive() && is_tax() && ! is_category() && ! is_tag() ) {
					$tax_object = get_queried_object();

					// Home page
					$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
					$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';

					if ( ! empty( $tax_object ) ) {
						$otf_title  = esc_html( $tax_object->name );
						$otf_output .= '<li class="list-inline-item item current">' . $otf_title . '</li>';
					}
				} else {
					if ( is_category() ) {
						// Home page
						$otf_title  = single_cat_title( '', false );
						$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
						$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';
						// Category page
						$otf_output .= '<li class="list-inline-item item current">' . $otf_title . '</li>';

					} else {
						if ( is_page() ) {
							$otf_title  = get_the_title();
							$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
							$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';

							// Standard page
							if ( $post->post_parent ) {

								// If child page, get parents
								$otf_anc = get_post_ancestors( $post->ID );

								// Get parents in the right order
								$otf_anc = array_reverse( $otf_anc );

								// Parent page loop
								foreach ( $otf_anc as $otf_ancestor ) {
									$otf_parents = '<li class="list-inline-item item"><a href="' . esc_url( get_permalink( $otf_ancestor ) ) . '" title="' . esc_attr( get_the_title( $otf_ancestor ) ) . '">' . get_the_title( $otf_ancestor ) . '</a></li>';
									$otf_parents .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';
								}

								// Display parent pages
								$otf_output .= $otf_parents;

								// Current page
								$otf_output .= '<li class="list-inline-item item current"> ' . $otf_title . '</li>';

							} else {

								// Just display current page if not parents
								$otf_output .= '<li class="list-inline-item item current"> ' . $otf_title . '</li>';

							}

						} else {
							if ( is_tag() ) {

								// Tag page
								$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
								$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';

								// Get tag information
								$otf_term_id  = get_query_var( 'tag_id' );
								$otf_taxonomy = 'post_tag';
								$otf_args     = 'include=' . $otf_term_id;
								$otf_terms    = get_terms( $otf_taxonomy, $otf_args );

								// Display the tag name
								if ( isset( $otf_terms[0]->name ) ) {
									$otf_title  = $otf_terms[0]->name;
									$otf_output .= '<li class="list-inline-item item current">' . $otf_terms[0]->name . '</li>';
								}

							} elseif ( is_day() ) {
								$otf_title = esc_html__( 'Day', 'givelove' );
								// Day archive

								// Year link
								$otf_output .= '<li class="list-inline-item item"><a href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . esc_html__( ' Archives', 'givelove' ) . '</a></li>';
								$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';

								// Month link
								$otf_output .= '<li class="list-inline-item item"><a href="' . esc_url( get_month_link( get_the_time( 'Y' ), get_the_time( 'm' ) ) ) . '" title="' . esc_attr( get_the_time( 'M' ) ) . '">' . get_the_time( 'M' ) . esc_html__( ' Archives', 'givelove' ) . '</a></li>';
								$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';

								// Day display
								$otf_output .= '<li class="list-inline-item item current"> ' . get_the_time( 'jS' ) . ' ' . get_the_time( 'M' ) . esc_html__( ' Archives', 'givelove' ) . '</li>';

							} else {
								if ( is_month() ) {
									$otf_title = esc_html__( 'Month', 'givelove' );
									// Month Archive

									// Year link
									$otf_output .= '<li class="list-inline-item item"><a href="' . esc_url( get_year_link( get_the_time( 'Y' ) ) ) . '" title="' . esc_attr( get_the_time( 'Y' ) ) . '">' . get_the_time( 'Y' ) . esc_html__( ' Archives', 'givelove' ) . '</a></li>';
									$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';

									// Month display
									$otf_output .= '<li class="list-inline-item item">' . get_the_time( 'M' ) . esc_html__( ' Archives', 'givelove' ) . '</li>';

								} else {
									if ( is_year() ) {
										$otf_title = esc_html__( 'Year', 'givelove' );
										// Display year archive
										$otf_output .= '<li class="list-inline-item item current">' . get_the_time( 'Y' ) . esc_html__( 'Archives', 'givelove' ) . '</li>';

									} else {
										if ( is_author() ) {
											global $author;
											if ( ! empty( $author->ID ) ) {
												$otf_userdata = get_userdata( $author->ID );
												// Display author name
												$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
												$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';
												$otf_title  = esc_html__( 'Author', 'givelove' );
												// Get the author information
												$otf_output .= '<li class="list-inline-item item current">' . esc_html__( 'Author: ', 'givelove' ) . '<a href="' . get_author_posts_url( $otf_userdata->ID, $otf_userdata->nice_name ) . '">' . $otf_userdata->display_name . '</a></li>';
											}

										} else {
											if ( get_query_var( 'paged' ) ) {

												// Paginated archives
												$otf_output .= '<li class="list-inline-item item current">' . esc_html__( 'Page', 'givelove' ) . ' ' . get_query_var( 'paged', '1' ) . '</li>';

											} else {
												if ( is_search() ) {
													$otf_title = esc_html__( 'Search', 'givelove' );
													// Search results page
													$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
													$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';
													$otf_output .= '<li class="list-inline-item item current">' . esc_html__( 'Keyword: ', 'givelove' ) . get_search_query() . '</li>';

												} elseif ( is_404() ) {
													$otf_title = esc_html__( 'Error 404', 'givelove' );
													// 404 page
													$otf_output .= '<li class="list-inline-item item home"><a href="' . esc_url( get_home_url() ) . '" title="' . esc_attr( $otf_home ) . '">' . $otf_home . '</a></li>';
													$otf_output .= '<li class="list-inline-item separator"> ' . $otf_sep . ' </li>';
													$otf_output .= '<li class="list-inline-item item current">' . $otf_title . '</li>';
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	$otf_output .= '</ul>';
} else {
	if ( ! is_front_page() ) {
		if ( is_home() ) {
			$otf_title = $otf_blog;
		} else {
			if ( is_single() ) {
				$otf_title        = get_the_title();
				$class_page_title = ' d-none';

			} else {
				if ( is_archive() && is_tax() && ! is_category() && ! is_tag() ) {
					$tax_object = get_queried_object();
					if ( ! empty( $tax_object ) ) {
						$otf_title = esc_html( $tax_object->name );

					}
				} else {
					if ( is_category() ) {
						// Home page
						$otf_title = single_cat_title( '', false );

					} else {
						if ( is_page() ) {

						} else {
							if ( is_tag() ) {
								// Get tag information
								$otf_term_id  = get_query_var( 'tag_id' );
								$otf_taxonomy = 'post_tag';
								$otf_args     = 'include=' . $otf_term_id;
								$otf_terms    = get_terms( $otf_taxonomy, $otf_args );

								// Display the tag name
								if ( isset( $otf_terms[0]->name ) ) {
									$otf_title = $otf_terms[0]->name;
								}

							} elseif ( is_day() ) {
								$otf_title = esc_html__( 'Day', 'givelove' );
							} else {
								if ( is_month() ) {
									$otf_title = esc_html__( 'Month', 'givelove' );
								} else {
									if ( is_year() ) {
										$otf_title = esc_html__( 'Year', 'givelove' );
									} else {
										if ( is_author() ) {
											global $author;
											if ( ! empty( $author->ID ) ) {
												$otf_title = esc_html__( 'Author', 'givelove' );
											}

										} else {
											if ( get_query_var( 'paged' ) ) {
											} else {
												if ( is_search() ) {
													$otf_title = esc_html__( 'Search', 'givelove' );

												} elseif ( is_404() ) {
													$otf_title = esc_html__( 'Error 404', 'givelove' );
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
}

$title_class = ( absint( givelove_get_metabox( get_the_ID(), 'osf_enable_page_heading', 1 ) ) != 0 ) ? '' : ' screen-reader-text';
?>
<div class="container">
    <div class="wrap w-100 d-flex align-items-center">
        <div class="page-title-bar-inner d-sm-flex justify-content-between align-items-center w-100">
            <div class="breadcrumb">
				<?php if ( function_exists( 'bcn_display' ) ): ?>
					<?php bcn_display(); ?>
				<?php else: ?>
					<?php echo wp_kses_post( $otf_output ); ?>
				<?php endif; ?>
            </div>
			<?php if ( is_page() && class_exists( 'GiveloveCore' ) ) { ?>
                <div class="page-header">
					<?php the_title( '<h1 class="page-title' . esc_attr( $title_class ) . '">', '</h1>' ); ?>
                </div>
			<?php } else {
				if ( is_404() && is_archive() && is_search() && is_home() ) {
					?>
                    <div class="page-header">
						<?php echo '<h1 class="page-title">' . $otf_title . '</h1>'; ?>
                    </div>
					<?php
				}
			} ?>
        </div>
    </div>
</div>
<svg class="shape-page-title-bar" enable-background="new 0 267.6 960 7.1" viewBox="0 267.6 960 7.1" xmlns="http://www.w3.org/2000/svg"><path d="m168.3 270.6c.3-.7.1-1 .4-1.7-.5 0-.8-.3-1.4-.1-.4 1-.2 1.7 1 1.8zm465.9 0c.3-.7 0-1 .4-1.7-.5 0-.8-.3-1.5-.1-.3 1-.2 1.7 1.1 1.8zm296.9 3c-.5-.1-1-.1-1.5-.2-3.1-.3-5 .2-5.7-1.7-3.3-.5-6.5.9-9.6.5-.7.2-1 .6-1.8.8-2.2-1.2-4.8-.3-7.3-.3-3.3 0-4.8-2.2-7.3-2.3-.3.2-.3.7-1 .6-2.5-.5-4.3.6-6.5.4-1.8-.1-2.8-1.3-4.5-1.8-3.3-.1-7.5-.1-10.5-.5-2-.3-4.3-1.4-5.6-1.5-1-.1-2.5 0-3.3.1-5.1.7-10.3 3-15.9 3.4-1 .1-2.2-.2-3.1-.1-2.5.1-4.7 1.3-7.5.9-.8.6-2 1.1-3.2 1-.5.3-.8.5-1.3.8h-13.3c-.2 0-.5-.1-.6-.1-.1.1-.2.1-.3.1h-16.2s0-.1-.1-.1c-1.8-.4-3.3 0-5.2-.4-1.3-.2-2.6-1.2-4-1.1-1 .1-1.7.9-2.5 1.1-1 .2-2.7-.2-4-.1-3.7.1-6.3.3-10-.4-.8-.7.6-.7.5-1.4-2.2-.6-5.7-.3-7.8 0-.8-.2-1.3-.5-2-.6-2.8-.3-7.3 1-9.8 1.1-2.3.1-4-.8-6.5-.6-2-3-6.8 1.8-10-.2-.1-.6.5-.8.7-1.3-3.6.4-6.7 1.7-10 1.3-2.8.6-5.2 1.8-7.7 2-1 .1-3 .4-4.2.3-1-.1-1.7-1-2.9-1.3-.7-.1-1.2.1-1.7 0-.7-.2-1-.7-1.8-.8s-2 .3-3 .4c-2.6.6-4.8 1.5-7.4 2h-2.4c-2.1-1-4.2-2.6-7-2.6-1.8 0-3.5.8-5.7.8-2.8-1.9-5.5-3.7-10.4-2.9-1 .1-1.7.8-2.5.9-2 .4-4.6.4-6.7.3-2.4-.1-4.5-.1-7.1-.3-.7.3-.9.8-1.8.8-1.2-.8-3.6-.5-3.5-2.2-2-.1-3.2-.9-5.7-.6-2.5 1.4-4.5 3.1-9.2 2.9-1.2 1.4-4.2 1.2-5.7.2-.7.3-.7 1-1.5 1.1-.8-.3-1.8-.4-2.7-.6 0 .7-1.1.7-1.8 1.1-.5.3-1.3.8-2 1.3h-5-.2-8.3c-2.5-1.5-5.2-1.5-8.7-1.6-.5.5-1 .9-1.7 1.3-3.6-.6-5.5-3.4-9.7-2.7-1.8 1.1-3.8 2.3-6.2 3h-16.1c-1.3-.4-2.7-.6-4.3-.5-.8 0-1.5.3-2 .5h-2.1c-2-.6-2.9-3-4.8-3.3-1.3-.2-1.7.8-3.1 1-3 .6-6.7.3-7.3-1-1.8.2-2.6-.4-4.2-.3-1.8 1-3.2 2.8-5.2 3.6h-5.7c-.7-.1-1.4-.1-2.1 0h-6.9c-3-.7-5.8-1.6-8.2-.6-.1.3-.2.5-.3.6h-7c-.5-.3-1.1-.5-2-.6-.3.3-.6.5-.9.6h-7.6c-.4-.3-.6-.6-.9-.9-2.5-.1-3.2-.8-5.9-.9-1.2.4-1.4 1.4-2.1 1.9h-2c-.5-.2-1-.5-1.5-.6-1.8-.7-3.2-.8-4-1.6-1.8.5-3.4 1.1-5.6 1.4-3.6.4-8-.1-11 .8h-2.2c-.5-.1-1-.1-1.5-.1-3.1-.3-5 .2-5.6-1.7-3.3-.5-6.5.9-9.6.5-.7.2-1 .6-1.9.8-2.2-1.2-4.9-.3-7.3-.3-3.3-.1-4.8-2.2-7.3-2.3-.3.2-.3.7-1 .6-2.5-.5-4.4.6-6.5.5-1.9-.2-2.8-1.3-4.5-1.9-3.3-.1-7.5-.1-10.5-.5-2-.3-4.4-1.4-5.6-1.5-1-.1-2.5 0-3.4.1-5.1.7-10.4 3-15.9 3.5-1 0-2.1-.2-3.1-.2-2.5.2-4.7 1.3-7.5.9-.9.5-2 1.1-3.1.9-.5.3-.8.6-1.3.8h-13.4c-.2-.1-.5-.1-.6-.2-.1.1-.1.1-.3.2h-16.1c0-.1 0-.1-.1-.2-1.8-.4-3.4 0-5.2-.3-1.3-.2-2.6-1.2-4-1.1-1 .1-1.6.9-2.5 1.1-1 .2-2.6-.2-4-.2-3.6.1-6.3.3-10-.4-.8-.6.6-.7.5-1.4-2.2-.6-5.7-.3-7.8 0-.8-.2-1.3-.6-2-.6-2.8-.3-7.3 1-9.8 1.1-2.3 0-4-.9-6.5-.6-2-3-6.9 1.9-10-.2-.1-.6.5-.8.6-1.3-3.6.4-6.7 1.7-10 1.3-2.9.6-5.1 1.8-7.7 2.1-1 .1-3 .4-4.2.3-.9 0-1.6-1-2.9-1.3-.6-.1-1.2.1-1.6 0-.7-.2-1.1-.7-1.9-.8s-2.1.3-2.9.5c-2.6.5-4.8 1.5-7.4 2h-2.4c-2.1-1-4.1-2.6-7.1-2.7-1.9 0-3.5.8-5.6.8-2.8-1.9-5.4-3.7-10.4-2.9-.9.1-1.6.8-2.5.9-1.9.4-4.6.4-6.7.3-2.4-.1-4.6-.1-7.1-.3-.7.3-.9.8-1.9.8-1.1-.8-3.6-.5-3.6-2.2-2.1-.1-3.2-.9-5.6-.6-2.4 1.5-4.6 3.1-9.2 3-1.1 1.3-4.2 1.2-5.6.1-.7.3-.6 1-1.4 1.1-.9-.3-1.9-.4-2.7-.6.1.7-1.1.7-1.9 1.1-.6.3-1.3.8-2.1 1.3h-5.1c-.1 0-.1 0-.2 0h-8.3c-2.4-1.6-5.2-1.5-8.6-1.6-.4.5-1 .9-1.6 1.3-3.6-.6-5.5-3.4-9.6-2.6-1.8 1.1-3.8 2.3-6.2 2.9h-16.4c-1.3-.4-2.7-.6-4.3-.5-.8.1-1.4.3-2.1.5h-2.1c-2-.6-2.9-3-4.8-3.3-1.3-.2-1.7.8-3.1 1.1-2.9.6-6.7.3-7.3-1.1-1.8.2-2.6-.4-4.2-.3-1.8 1-3.2 2.8-5.2 3.6h-5.7c-.7-.1-1.4-.1-2.1 0h-.1-6.5c-3-.7-5.8-1.6-8.2-.7-.1.3-.2.5-.3.7h-7c-.5-.3-1.2-.6-2-.7-.3.3-.6.5-.9.7h-7.7c-.3-.3-.7-.6-.8-1-2.5 0-3.2-.8-5.9-.9-1.2.4-1.4 1.4-2.1 1.9h-2c-.5-.2-1-.5-1.5-.6-1.8-.7-3.2-.8-4-1.6-1.8.5-3.4 1.2-5.6 1.4-3.6.4-8-.2-10.9.8h-1.6v.8-.1h960v-.9h-28.9z"/></svg>
